﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.DataModel;


namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class GetIntegrationSettingsStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            var _consultstatusstring = "vista-consultstatus";
            var _apptokenstatusstring = "VIA Consuming App Token";
            var _apppasswordstatusstring = "VIA Consuming App Password";
            var _fakeResponse = "vista-getconsultfakeresponsetype";
           
            //var _mcs_localpid = "vista-mcs-localpid";
            //var _mcs_localsiteid = "vista-mcs-localsiteid";
            //var _mcs_mpipid = "vista-mcs-mpipid";
            //var _mcs_vistalocation = "vista-location";

            /*
                var RequestingAppRecord = ViaSettings.FirstOrDefault(s => s.mcs_name == "VIA Requesting App");
                var ConsumingAppRecord = ViaSettings.FirstOrDefault(s => s.mcs_name == "VIA Consuming App Token");
                var ConsumingAppPasswordRecord = ViaSettings.FirstOrDefault(s => s.mcs_name == "VIA Consuming App Password");
            */


            using (var _service = new Xrm(state.OrganizationServiceProxy)) {
               var _consultstatus = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _consultstatusstring);
                if (_consultstatus == null) { throw new Exception("Vista Consult Status Integration Setting Could Not Be Found:" + _consultstatusstring); }
                state.mcs_status = _consultstatus.mcs_value;

                var via_apptoken = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _apptokenstatusstring);
                if (via_apptoken == null) { throw new Exception("Vista App Token Could Not Be Found:" + via_apptoken); }
                state.Via_AppToken = via_apptoken.mcs_value;

                var via_apppassword = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _apppasswordstatusstring);
                if (via_apppassword == null) { throw new Exception("Vista App Password Could Not Be Found:" + _apppasswordstatusstring); }
                state.Via_AppPassword = via_apppassword.mcs_value;

                var via_fakeresponse = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _fakeResponse);
                if (via_fakeresponse == null) { state.ConsultsFakeResponseType = string.Empty; } else { state.ConsultsFakeResponseType = via_fakeresponse.mcs_value; }


                //var via_mcs_localpid = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _mcs_localpid);
                //if(_mcs_localpid==null) { throw new Exception("LocalPid Could Not Be Found:" + _mcs_localpid); }
                //state.mcs_localPid = via_mcs_localpid.mcs_value;

                //var via_mcs_localsiteid = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _mcs_localsiteid);
                //if(_mcs_localsiteid==null) { throw new Exception("LocalSiteId Could Not Be Found:" + _mcs_localsiteid); }
                //state.mcs_localSiteId = via_mcs_localsiteid.mcs_value;

                //var via_mcs_mpipid = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _mcs_mpipid);
                //if (_mcs_mpipid == null) { throw new Exception("Mpi Pid Could Not Be Found:" + _mcs_mpipid); }
                //state.mcs_mpiPid = via_mcs_mpipid.mcs_value;

                //var via_mcs_vistalocation = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == _mcs_vistalocation);
                //if(_mcs_vistalocation==null) { throw new Exception("Vista Location Could Not Be Found:" + _mcs_vistalocation); }
                //state.mcs_vistaLocation = via_mcs_vistalocation.mcs_value;
            }
        }
    }
}
